/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.internal.ui.actions.ASNDTQuickMenuAction;
import org.asnlab.asndt.internal.ui.actions.ActionMessages;
import org.asnlab.asndt.internal.ui.actions.AddTaskAction;
import org.asnlab.asndt.internal.ui.actions.CleanUpAction;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.asnlab.asndt.ui.source.menu";
    public static final String GROUP_IMPORT = "importGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_EXTERNALIZE = "externalizeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    private static final String GROUP_EDIT = "editGroup";
    private CompilationUnitEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private CleanUpAction fCleanUp;
    private static final String QUICK_MENU_ID = "org.asnlab.asndt.ui.edit.text.asn.source.quickMenu";
    private RefactorQuickAccessAction fQuickAccessAction;
    private IKeyBindingService fKeyBindingService;

    public GenerateActionGroup(CompilationUnitEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.fCleanUp = new CleanUpAction(editor);
        this.fCleanUp.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.clean.up");
        editor.setAction("CleanUp", (IAction)this.fCleanUp);
        this.fQuickAccessAction = new RefactorQuickAccessAction(editor);
        this.fKeyBindingService = editor.getEditorSite().getKeyBindingService();
        this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getKeyBindingService());
    }

    private GenerateActionGroup(IWorkbenchSite site, IKeyBindingService keyBindingService) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddBookmark = new AddBookmarkAction(site.getShell());
        this.fAddBookmark.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.fAddTaskAction = new AddTaskAction(site);
        this.fAddTaskAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.fCleanUp = new CleanUpAction(site);
        this.fCleanUp.setActionDefinitionId("org.asnlab.asndt.ui.edit.text.asn.clean.up");
        this.fCleanUp.update(selection);
        this.fAddTaskAction.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, this.fAddTaskAction);
        this.registerSelectionListener(provider, this.fCleanUp);
        this.fKeyBindingService = keyBindingService;
        if (this.fKeyBindingService != null) {
            this.fQuickAccessAction = new RefactorQuickAccessAction(null);
            this.fKeyBindingService.registerAction((IAction)this.fQuickAccessAction);
        }
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = ActionMessages.SourceMenu_label;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "Indent");
        added += this.addEditorAction(source, "Format");
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        source.add((IContributionItem)new Separator(GROUP_GENERATE));
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            for (ISelectionChangedListener listener : this.fRegisteredSelectionListeners) {
                provider.removeSelectionChangedListener(listener);
            }
        }
        if (this.fQuickAccessAction != null && this.fKeyBindingService != null) {
            this.fKeyBindingService.unregisterAction((IAction)this.fQuickAccessAction);
        }
        this.fEditor = null;
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.asnlab.asndt.ui.actions.CleanUp", (IAction)this.fCleanUp);
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
        }
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    private class RefactorQuickAccessAction
    extends ASNDTQuickMenuAction {
        public RefactorQuickAccessAction(CompilationUnitEditor editor) {
            super(editor, GenerateActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            GenerateActionGroup.this.fillQuickMenu(menu);
        }
    }
}

