/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text.asn;

import java.util.ArrayList;
import java.util.List;
import org.asnlab.asndt.internal.ui.text.AbstractAsnScanner;
import org.asnlab.asndt.internal.ui.text.AsnWordDetector;
import org.asnlab.asndt.internal.ui.text.AsnWordRule;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsnCodeScanner
extends AbstractAsnScanner {
    public static String[] fgBuiltInTypeKeywords = new String[]{"BOOLEAN", "INTEGER", "REAL", "BIT STRING", "OCTET STRING", "NULL", "OBJECT IDENTIFIER", "ObjectDescriptor", "UTCTime", "GeneralizedTime", "NumericString", "PrintableString", "VisibleString", "ISO646String", "IA5String", "TeletexString", "T61String", "VideotexString", "GraphicString", "GeneralString", "UniversalString", "BMPString", "UTF8String", "ANY ", "EMBEDDED PDV", "CHARACTER STRING", "EXTERNAL", "RELATIVE-OID", "INSTANCE OF", "FALSE", "MINUS-INFINITY", "PLUS-INFINITY", "TRUE"};
    public static String[] fgTaggingKeywords = new String[]{"AUTOMATIC", "EXPLICIT", "IMPLICIT", "TAGS", "APPLICATION", "UNIVERSAL", "PRIVATE"};
    public static String[] fgConstraintKeywords = new String[]{"SIZE", "UNION", "INTERSECTION", "EXCEPT", "MIN", "MAX", "ALL", "CONSTRAINED BY", "WITH COMPONENT", "WITH COMPONENTS", "PRESENT", "ABSENT", "INCLUDES"};
    public static String[] fgOptionalityKeywords = new String[]{"DEFAULT", "OPTIONAL", "UNIQUE"};
    public static String[] fgKeywords = new String[]{"ANY DEFINED BY", "BEGIN", "CHOICE", "CLASS", "CONTAINING", "COMPONENTS OF", "DEFINITIONS", "END", "ENUMERATED", "EXPORTS", "ENCODED BY", "EXTENSIBILITY IMPLIED", "FROM", "IMPORTS", "OF", "SEQUENCE", "SET", "TYPE OF", "WITH SYNTAX"};
    private static String[] fgTokenProperties = new String[]{"asn_string", "asn_built_in_type_keyword", "asn_tagging_keyword", "asn_constraint_keyword", "asn_optionality", "asn_keyword", "asn_default"};

    public AsnCodeScanner(IColorManager manager, IPreferenceStore store) {
        super(manager, store);
        this.initialize();
    }

    @Override
    protected String[] getTokenProperties() {
        return fgTokenProperties;
    }

    @Override
    protected List<IRule> createRules() {
        Token defaultToken = this.getToken("asn_default");
        ArrayList<IRule> rules = new ArrayList<IRule>();
        Token token = this.getToken("asn_string");
        rules.add((IRule)new MultiLineRule("\"", "\"", (IToken)token, '\"'));
        rules.add((IRule)new SingleLineRule("'", "'", (IToken)token));
        AsnWordDetector wordDetector = new AsnWordDetector();
        AsnWordRule wordRule = new AsnWordRule(wordDetector, (IToken)defaultToken);
        token = this.getToken("asn_built_in_type_keyword");
        int i = 0;
        while (i < fgBuiltInTypeKeywords.length) {
            wordRule.addWord(fgBuiltInTypeKeywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("asn_tagging_keyword");
        i = 0;
        while (i < fgTaggingKeywords.length) {
            wordRule.addWord(fgTaggingKeywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("asn_constraint_keyword");
        i = 0;
        while (i < fgConstraintKeywords.length) {
            wordRule.addWord(fgConstraintKeywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("asn_optionality");
        i = 0;
        while (i < fgOptionalityKeywords.length) {
            wordRule.addWord(fgOptionalityKeywords[i], (IToken)token);
            ++i;
        }
        token = this.getToken("asn_keyword");
        i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)token);
            ++i;
        }
        rules.add(wordRule);
        this.setDefaultReturnToken((IToken)defaultToken);
        return rules;
    }
}

