/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.template.asn;

import java.lang.reflect.InvocationTargetException;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.template.asn.AsnFormatter;
import org.asnlab.asndt.internal.corext.template.asn.AsnTemplateMessages;
import org.asnlab.asndt.internal.corext.template.asn.CompilationUnitContext;
import org.asnlab.asndt.internal.corext.util.Strings;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.text.template.contentassist.MultiVariable;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.widgets.Shell;

public class AsnContext
extends CompilationUnitContext {
    public AsnContext(TemplateContextType type, IDocument document, int completionOffset, int completionLength, ICompilationUnit compilationUnit) {
        super(type, document, completionOffset, completionLength, compilationUnit);
    }

    public AsnContext(TemplateContextType type, IDocument document, Position completionPosition, ICompilationUnit compilationUnit) {
        super(type, document, completionPosition, compilationUnit);
    }

    private int getIndentation() {
        int start = this.getStart();
        IDocument document = this.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(start);
            String lineContent = document.get(region.getOffset(), region.getLength());
            ICompilationUnit compilationUnit = this.getCompilationUnit();
            IAsnProject project = compilationUnit == null ? null : compilationUnit.getAsnProject();
            return Strings.computeIndentUnits(lineContent, project);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        if (!this.canEvaluate(template)) {
            throw new TemplateException(AsnTemplateMessages.Context_error_cannot_evaluate);
        }
        TemplateTranslator translator = new TemplateTranslator(){

            protected TemplateVariable createVariable(String type, String name, int[] offsets) {
                return new MultiVariable(type, name, offsets);
            }
        };
        TemplateBuffer buffer = translator.translate(template);
        this.getContextType().resolve(buffer, (TemplateContext)this);
        IPreferenceStore prefs = AsnPlugin.getDefault().getPreferenceStore();
        boolean useCodeFormatter = prefs.getBoolean("org.asnlab.asndt.ui.template.format");
        IAsnProject project = this.getCompilationUnit() != null ? this.getCompilationUnit().getAsnProject() : null;
        AsnFormatter formatter = new AsnFormatter(TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument()), this.getIndentation(), useCodeFormatter, project);
        formatter.format(buffer, (TemplateContext)this);
        return buffer;
    }

    public boolean canEvaluate(Template template) {
        if (this.fForceEvaluation) {
            return true;
        }
        String key = this.getKey();
        return template.matches(key, this.getContextType().getId()) && key.length() != 0 && template.getName().toLowerCase().startsWith(key.toLowerCase());
    }

    public int getStart() {
        if (this.fIsManaged && this.getCompletionLength() > 0) {
            return super.getStart();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != 0 && Character.isUnicodeIdentifierPart(document.getChar(start - 1))) {
                --start;
            }
            while (start != end && Character.isWhitespace(document.getChar(start))) {
                ++start;
            }
            if (start == end) {
                start = this.getCompletionOffset();
            }
            return start;
        }
        catch (BadLocationException badLocationException) {
            return super.getStart();
        }
    }

    public int getEnd() {
        if (this.fIsManaged || this.getCompletionLength() == 0) {
            return super.getEnd();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getCompletionOffset();
            int end = this.getCompletionOffset() + this.getCompletionLength();
            while (start != end && Character.isWhitespace(document.getChar(end - 1))) {
                --end;
            }
            return end;
        }
        catch (BadLocationException badLocationException) {
            return super.getEnd();
        }
    }

    public String getKey() {
        if (this.getCompletionLength() == 0) {
            return super.getKey();
        }
        try {
            IDocument document = this.getDocument();
            int start = this.getStart();
            int end = this.getCompletionOffset();
            return start <= end ? document.get(start, end - start) : "";
        }
        catch (BadLocationException badLocationException) {
            return super.getKey();
        }
    }

    public char getCharacterBeforeStart() {
        int start = this.getStart();
        try {
            return start == 0 ? (char)' ' : this.getDocument().getChar(start - 1);
        }
        catch (BadLocationException badLocationException) {
            return ' ';
        }
    }

    private static void handleException(Shell shell, Exception e) {
        String title = AsnTemplateMessages.AsnContext_error_title;
        if (e instanceof CoreException) {
            ExceptionHandler.handle((CoreException)((Object)e), shell, title, null);
        } else if (e instanceof InvocationTargetException) {
            ExceptionHandler.handle((InvocationTargetException)e, shell, title, null);
        } else {
            AsnPlugin.log(e);
            MessageDialog.openError((Shell)shell, (String)title, (String)e.getMessage());
        }
    }

    public static String evaluateTemplate(Template template, ICompilationUnit compilationUnit, int position) throws CoreException, BadLocationException, TemplateException {
        TemplateContextType contextType = AsnPlugin.getDefault().getTemplateContextRegistry().getContextType("asn");
        if (contextType == null) {
            throw new CoreException((IStatus)new Status(4, "org.asnlab.asndt.ui", 4, AsnTemplateMessages.AsnContext_error_message, null));
        }
        Document document = new Document();
        if (compilationUnit != null && compilationUnit.exists()) {
            document.set(compilationUnit.getSource());
        }
        AsnContext context = new AsnContext(contextType, (IDocument)document, position, 0, compilationUnit);
        context.setForceEvaluation(true);
        TemplateBuffer buffer = context.evaluate(template);
        if (buffer == null) {
            return null;
        }
        return buffer.getString();
    }
}

